'use strict';

var extendedApp = angular.module('businessGameAdminExtended', []);

extendedApp.config(['$routeProvider', function($routeProvider) {
    $routeProvider
        .when('/teachers_accounts', {
            templateUrl: '/admin/partials/teachers/main.html'
        })
        .when('/ranking', {
            templateUrl: '/admin/partials/ranking/main.html'
        });
}]);


extendedApp.run(['NavigationItems', 'AppConfig', function(NavigationItems, AppConfig){
    extendStaticNavigationItems(NavigationItems);
    extendAppConfig(AppConfig);
}]);
var extendAppConfig = function(AppConfig){
    AppConfig.urlTeachersAccounts = appDev + '/admin/api/teachers';
};

var extendStaticNavigationItems = function(NavigationItems){
    var items = NavigationItems.getItems();
    items.push({
        name: 'Konta nauczycieli'
        ,link: 'teachers_accounts'
        ,type: 'teachers_accounts'
        ,title: 'Zarządzanie kontami nauczycieli'
        ,iconCls: 'fa fa-users'
    });

    items.push({
        name: 'Ranking'
        ,link: 'ranking'
        ,type: 'ranking'
        ,title: 'Ranking wszystkich grup'
        ,iconCls: 'fa fa-users'
    });

    var itemsToDelete = [];
    angular.forEach(items, function(value, key){
        if(value.name == 'Wskaźniki' || value.name == 'Notowania'){
            itemsToDelete.push(value)
        }
    });

//    console.log(keysToDelete);
//    console.log(items);
    angular.forEach(itemsToDelete, function(item){
        items.splice(items.indexOf(item), 1);
    });
};